from tkinter import *
from tkinter import ttk, font, filedialog as fd
import shutil, os, ctypes, pyglet
from fractions import Fraction
from PIL import ImageTk, Image, ImageOps, ImageDraw, ImageFont
import Program
from Edit_and_add_recipes import Edit_and_add_recipes
import Recipes_frame
from Edit_and_add_ingredients import Edit_and_add_ingredients

class Side_frame(Frame):
    """
    Purpose:
        frame sidebar that allows you to go to edit ingredients and recipes frames
    Instance variables:
        self.top_frame: frame that containts side menu button,
            my popular recipes button, and popular recipes button
        self.close_side_menu_button: button that closes the side menu if clicked
        self.side_menu_my_recipe_button: does nothing currently, will
            open a list of saved recipes
        self.popular_recipe_button: does nothing currently, will open a list of
            popular recipes
        self.lower_frame: frame that contains change and edit recipe buttons
        self.change_recipe: opens a menu to change recipes if clicked
        self.change_ingredients: opens a menu to change ingredients if clicked
    Methods:
        open_menu: opens the side menu frame
        close_menu: closes side menu frame
    """

    def __init__(self, parent):
        Frame.__init__(self, parent)
        self.top_frame = Frame(self)
        self.top_frame.pack(fill="x")
        self.top_frame.grid_columnconfigure(0, weight=1)
        self.close_side_menu_button = Button(
            self.top_frame, text="|||", command=lambda: self.close_menu()
        )
        self.close_side_menu_button.grid(row=0, column=0, sticky="e")
        # To be added
        self.side_menu_my_recipe_button = Button(
            self.top_frame, text="My Recipes", activebackground="green"
        )
        self.side_menu_my_recipe_button.grid(row=1, column=0, pady=5)
        self.popular_recipe_button = Button(
            self.top_frame, text="Popular Recipes", activebackground="green"
        )
        self.popular_recipe_button.grid(row=2, column=0, pady=5)
        self["highlightbackground"] = "black"
        self["highlightthickness"] = 2

        self.lower_frame = Frame(self)
        self.lower_frame.pack(side="bottom", pady=(0, 20))

        self.light_mode_check_var = IntVar()
        self.light_mode_check_button = Checkbutton(
            self.lower_frame,
            text="Light Mode",
            command=lambda: self.toggle_light_mode(),
            onvalue=True,
            offvalue=False,
            variable=self.light_mode_check_var,
        )
        self.light_mode_check_button.grid(row=0, column=0, pady=5)
        self.primary_color_label = Label(self.lower_frame, text="Primary Hex Color:")
        self.primary_color_label.grid(row=1, column=0)
        self.primary_color_entry = Entry(self.lower_frame, width=8)
        self.primary_color_entry.bind(
            "<KeyRelease>",
            lambda event: self.change_primary_color(),
        )
        self.primary_color_entry.grid(row=2, column=0, pady=5)
        self.secondary_color_label = Label(
            self.lower_frame, text="Secondary Hex Color:"
        )
        self.secondary_color_label.grid(row=3, column=0)
        self.secondary_color_entry = Entry(self.lower_frame, width=8)
        self.secondary_color_entry.bind(
            "<KeyRelease>",
            lambda event: self.change_secondary_color(),
        )
        self.secondary_color_entry.grid(row=4, column=0, pady=5)
        self.change_recipe = Button(
            self.lower_frame,
            text="Change Recipes",
            command=lambda: Program.Program.controller.change_frames(Edit_and_add_recipes),
        )
        self.change_recipe.grid(row=5, column=0, pady=5)
        self.change_ingredients = Button(
            self.lower_frame,
            text="Change Ingredients",
            command=lambda: Program.Program.controller.change_frames(Edit_and_add_ingredients),
        )
        self.change_ingredients.grid(row=6, column=0, pady=5)

    def toggle_light_mode(self):
        Program.Program.light_mode = bool(self.light_mode_check_var.get())
        if Program.Program.light_mode:
            color_mode = "#FFFFFF"
        else:
            color_mode = "#121212"
        Program.Program.change_program_colors(
            color_mode,
            self.primary_color_label["bg"],
            "#3700B3",
            self.secondary_color_label["bg"],
        )

    def change_primary_color(self):
        try:
            text = self.primary_color_entry.get().strip("#")
            if len(text) == 6 and text != self.primary_color_entry["bg"].strip("#"):
                Program.Program.convert_hex_to_rgb(text)
                if Program.Program.light_mode:
                    color_mode = "#FFFFFF"
                else:
                    color_mode = "#121212"
                Program.Program.change_program_colors(
                    color_mode,
                    "#" + text,
                    "#3700B3",
                    self.secondary_color_label["bg"],
                )
        except:
            None

    def change_secondary_color(self):
        try:
            text = self.secondary_color_entry.get().strip("#")
            if len(text) == 6 and text != self.secondary_color_entry["bg"].strip("#"):
                Program.Program.convert_hex_to_rgb(text)
                if Program.Program.light_mode:
                    color_mode = "#FFFFFF"
                else:
                    color_mode = "#121212"
                Program.Program.change_program_colors(
                    color_mode,
                    self.primary_color_label["bg"],
                    "#3700B3",
                    "#" + text,
                )
        except:
            None

    def open_menu(self):
        Program.Program.controller.change_frames(Side_frame, False)
        Program.Program.controller.detect_click_outside_frame(
            Program.Program.controller.frames[Recipes_frame.Recipes_frame], self
        )

    def close_menu(self):
        Program.Program.controller.unbind("<Button-1>")
        Program.Program.controller.change_frames(Recipes_frame.Recipes_frame)

    def change_colors(self, bg_color, primary_color, primary_variant, secondary_color):
        elevation_bg_color = Program.Program.convert_rgb_to_hex(
            Program.Program.overlay_colors(
                Program.Program.convert_hex_to_rgb(bg_color), (255, 255, 255), 0.11
            )
        )
        if Program.Program.light_mode:
            button_text_color = "#FFFFFF"
            label_color = Program.Program.convert_rgb_to_hex(
                Program.Program.overlay_colors(
                    Program.Program.convert_hex_to_rgb(elevation_bg_color), (0, 0, 0), 0.87
                )
            )
        else:
            button_text_color = "#000000"
            label_color = Program.Program.convert_rgb_to_hex(
                Program.Program.overlay_colors(
                    Program.Program.convert_hex_to_rgb(elevation_bg_color),
                    (255, 255, 255),
                    0.87,
                )
            )
        self.config(bg=elevation_bg_color)
        self.top_frame.config(bg=elevation_bg_color)
        self.lower_frame.config(bg=elevation_bg_color)
        self.close_side_menu_button.config(
            bg=primary_color,
            fg=Program.Program.convert_rgb_to_hex(
                Program.Program.overlay_colors(
                    Program.Program.convert_hex_to_rgb(primary_color),
                    Program.Program.convert_hex_to_rgb(button_text_color),
                    0.87,
                )
            ),
            border="0",
            relief="flat",
            borderwidth=0,
            highlightthickness=0,
            activebackground=primary_color,
        )

        self.side_menu_my_recipe_button_image = Program.Program.create_rounded_button_image(
            elevation_bg_color,
            primary_color,
            Program.Program.convert_rgb_to_hex(
                Program.Program.overlay_colors(
                    Program.Program.convert_hex_to_rgb(primary_color),
                    Program.Program.convert_hex_to_rgb(button_text_color),
                    0.87,
                )
            ),
            "My Recipes",
            self.side_menu_my_recipe_button.winfo_width(),
            self.side_menu_my_recipe_button.winfo_height(),
            22,
        )
        self.side_menu_my_recipe_button.config(
            border="0",
            relief="flat",
            borderwidth=0,
            highlightthickness=0,
            activebackground="green",
            image=self.side_menu_my_recipe_button_image,
        )

        self.popular_recipe_button_image = Program.Program.create_rounded_button_image(
            elevation_bg_color,
            primary_color,
            Program.Program.convert_rgb_to_hex(
                Program.Program.overlay_colors(
                    Program.Program.convert_hex_to_rgb(primary_color),
                    Program.Program.convert_hex_to_rgb(button_text_color),
                    0.87,
                )
            ),
            "Popular Recipes",
            self.popular_recipe_button.winfo_width(),
            self.popular_recipe_button.winfo_height(),
            22,
        )
        self.popular_recipe_button.config(
            border="0",
            relief="flat",
            borderwidth=0,
            highlightthickness=0,
            activebackground="green",
            image=self.popular_recipe_button_image,
        )
        if Program.Program.light_mode:
            self.light_mode_check_button.config(
                bg=elevation_bg_color,
                fg=label_color,
                activebackground="#121212",
                activeforeground=Program.Program.convert_rgb_to_hex(
                    Program.Program.overlay_colors(
                        Program.Program.convert_hex_to_rgb("#121212"),
                        Program.Program.convert_hex_to_rgb("#FFFFFF"),
                        0.87,
                    )
                ),
            )
        else:
            self.light_mode_check_button.config(
                bg=elevation_bg_color,
                fg=label_color,
                activebackground="#FFFFFF",
                activeforeground=Program.Program.convert_rgb_to_hex(
                    Program.Program.overlay_colors(
                        Program.Program.convert_hex_to_rgb("#FFFFFF"),
                        Program.Program.convert_hex_to_rgb("#000000"),
                        0.87,
                    )
                ),
            )
        primary_color_text = Program.Program.convert_rgb_to_hex(
            Program.Program.overlay_colors(
                Program.Program.convert_hex_to_rgb(primary_color),
                Program.Program.convert_hex_to_rgb(button_text_color),
                0.87,
            )
        )
        self.primary_color_label.config(
            bg=primary_color,
            fg=primary_color_text,
        )
        self.primary_color_entry.config(bg=primary_color, fg=primary_color_text)
        secondary_color_text = Program.Program.convert_rgb_to_hex(
            Program.Program.overlay_colors(
                Program.Program.convert_hex_to_rgb(secondary_color),
                Program.Program.convert_hex_to_rgb(button_text_color),
                0.87,
            )
        )
        self.secondary_color_label.config(
            bg=secondary_color,
            fg=secondary_color_text,
        )
        self.secondary_color_entry.config(bg=secondary_color, fg=secondary_color_text)
        self.change_recipe_image = Program.Program.create_rounded_button_image(
            elevation_bg_color,
            primary_color,
            Program.Program.convert_rgb_to_hex(
                Program.Program.overlay_colors(
                    Program.Program.convert_hex_to_rgb(primary_color),
                    Program.Program.convert_hex_to_rgb(button_text_color),
                    0.87,
                )
            ),
            "Change Recipes",
            self.change_recipe.winfo_width(),
            self.change_recipe.winfo_height(),
            22,
        )
        self.change_recipe.config(
            border="0",
            relief="flat",
            borderwidth=0,
            highlightthickness=0,
            activebackground=elevation_bg_color,
            image=self.change_recipe_image,
        )

        self.change_ingredients_image = Program.Program.create_rounded_button_image(
            elevation_bg_color,
            primary_color,
            Program.Program.convert_rgb_to_hex(
                Program.Program.overlay_colors(
                    Program.Program.convert_hex_to_rgb(primary_color),
                    Program.Program.convert_hex_to_rgb(button_text_color),
                    0.87,
                )
            ),
            "Change Ingredients",
            self.change_ingredients.winfo_width(),
            self.change_ingredients.winfo_height(),
            22,
        )
        self.change_ingredients.config(
            border="0",
            relief="flat",
            borderwidth=0,
            highlightthickness=0,
            activebackground=elevation_bg_color,
            image=self.change_ingredients_image,
        )
        self.primary_color_entry.delete(0, END)
        self.primary_color_entry.insert(0, self.primary_color_entry["bg"])
        self.secondary_color_entry.delete(0, END)
        self.secondary_color_entry.insert(0, self.secondary_color_entry["bg"])